/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.xdebug;

import com.aptana.php.debug.core.preferences.PHPDebugPreferencesUtil;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org2.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpPreferences;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandler;

public class XDebugPreferenceMgr {
    public static final String XDEBUG_PREF_PORT = "com.aptana.php.debug.epl.xdebug_port";
    public static final String XDEBUG_PREF_SHOWSUPERGLOBALS = "com.aptana.php.debug.epl.xdebug_showSuperGlobals";
    public static final String XDEBUG_PREF_ARRAYDEPTH = "com.aptana.php.debug.epl.xdebug_arrayDepth";
    public static final String XDEBUG_PREF_CHILDREN = "com.aptana.php.debug.epl.xdebug_children";
    public static final String XDEBUG_PREF_MULTISESSION = "com.aptana.php.debug.epl.xdebug_multisession";
    public static final String XDEBUG_PREF_REMOTESESSION = "com.aptana.php.debug.epl.xdebug_remotesession";
    public static final String XDEBUG_PREF_CAPTURESTDOUT = "com.aptana.php.debug.epl.xdebug_capturestdout";
    public static final String XDEBUG_PREF_CAPTURESTDERR = "com.aptana.php.debug.epl.xdebug_capturestderr";
    public static final String XDEBUG_PREF_USEPROXY = "com.aptana.php.debug.epl.xdebug_useproxy";
    public static final String XDEBUG_PREF_IDEKEY = "com.aptana.php.debug.epl.xdebug_idekey";
    public static final String XDEBUG_PREF_PROXY = "com.aptana.php.debug.epl.xdebug_proxy";
    public static final String[] remoteSessionOptions = new String[]{PHPDebugCoreMessages.XDebugConfigurationDialog_remoteSessionOption_off, PHPDebugCoreMessages.XDebugConfigurationDialog_remoteSessionOption_localhost, PHPDebugCoreMessages.XDebugConfigurationDialog_remoteSessionOption_any, PHPDebugCoreMessages.XDebugConfigurationDialog_remoteSessionOption_prompt};
    public static final String[] captureOutputOptions = new String[]{PHPDebugCoreMessages.XDebugConfigurationDialog_capture_off, PHPDebugCoreMessages.XDebugConfigurationDialog_capture_copy, PHPDebugCoreMessages.XDebugConfigurationDialog_capture_redirect};

    public static void setDefaults() {
        IEclipsePreferences prefs = new DefaultScope().getNode("com.aptana.php.debug.epl");
        prefs.putInt(XDEBUG_PREF_PORT, XDebugPreferenceMgr.getPortDefault());
        prefs.putBoolean(XDEBUG_PREF_SHOWSUPERGLOBALS, XDebugPreferenceMgr.showSuperGlobalsDefault());
        prefs.putInt(XDEBUG_PREF_ARRAYDEPTH, XDebugPreferenceMgr.getDepthDefault());
        prefs.putBoolean(XDEBUG_PREF_MULTISESSION, XDebugPreferenceMgr.useMultiSessionDefault());
        prefs.putInt(XDEBUG_PREF_CHILDREN, XDebugPreferenceMgr.getChildrenDefault());
        prefs.putInt(XDEBUG_PREF_REMOTESESSION, XDebugPreferenceMgr.getAcceptRemoteSessionDefault());
        prefs.putInt(XDEBUG_PREF_CAPTURESTDOUT, XDebugPreferenceMgr.getCaptureDefault());
        prefs.putInt(XDEBUG_PREF_CAPTURESTDERR, XDebugPreferenceMgr.getCaptureDefault());
    }

    public static void applyDefaults(IEclipsePreferences preferences) {
        IPreferencesService service = Platform.getPreferencesService();
        IScopeContext[] defaultContext = new IScopeContext[]{new DefaultScope()};
        preferences.putInt(XDEBUG_PREF_PORT, service.getInt("com.aptana.php.debug.epl", XDEBUG_PREF_PORT, XDebugPreferenceMgr.getPortDefault(), defaultContext));
        preferences.putBoolean(XDEBUG_PREF_SHOWSUPERGLOBALS, service.getBoolean("com.aptana.php.debug.epl", XDEBUG_PREF_SHOWSUPERGLOBALS, XDebugPreferenceMgr.showSuperGlobalsDefault(), defaultContext));
        preferences.putInt(XDEBUG_PREF_ARRAYDEPTH, service.getInt("com.aptana.php.debug.epl", XDEBUG_PREF_ARRAYDEPTH, XDebugPreferenceMgr.getDepthDefault(), defaultContext));
        preferences.putInt(XDEBUG_PREF_CHILDREN, service.getInt("com.aptana.php.debug.epl", XDEBUG_PREF_CHILDREN, XDebugPreferenceMgr.getChildrenDefault(), defaultContext));
        preferences.putBoolean(XDEBUG_PREF_MULTISESSION, service.getBoolean("com.aptana.php.debug.epl", XDEBUG_PREF_MULTISESSION, XDebugPreferenceMgr.useMultiSessionDefault(), defaultContext));
        preferences.putInt(XDEBUG_PREF_REMOTESESSION, service.getInt("com.aptana.php.debug.epl", XDEBUG_PREF_REMOTESESSION, XDebugPreferenceMgr.getAcceptRemoteSessionDefault(), defaultContext));
        preferences.putInt(XDEBUG_PREF_CAPTURESTDOUT, service.getInt("com.aptana.php.debug.epl", XDEBUG_PREF_CAPTURESTDOUT, XDebugPreferenceMgr.getCaptureDefault(), defaultContext));
        preferences.putInt(XDEBUG_PREF_CAPTURESTDERR, service.getInt("com.aptana.php.debug.epl", XDEBUG_PREF_CAPTURESTDERR, XDebugPreferenceMgr.getCaptureDefault(), defaultContext));
        preferences.putBoolean(XDEBUG_PREF_USEPROXY, service.getBoolean("com.aptana.php.debug.epl", XDEBUG_PREF_USEPROXY, false, defaultContext));
        preferences.put(XDEBUG_PREF_IDEKEY, service.getString("com.aptana.php.debug.epl", XDEBUG_PREF_IDEKEY, DBGpProxyHandler.instance.generateIDEKey(), defaultContext));
        preferences.putBoolean(XDEBUG_PREF_PROXY, service.getBoolean("com.aptana.php.debug.epl", XDEBUG_PREF_PROXY, false, defaultContext));
    }

    public static DBGpPreferences createSessionPreferences() {
        DBGpPreferences sessionPrefs = new DBGpPreferences();
        int maxDepth = PHPDebugPreferencesUtil.getInt(XDEBUG_PREF_ARRAYDEPTH, XDebugPreferenceMgr.getDepthDefault());
        if (1 == maxDepth) {
            XDebugPreferenceMgr.setDefaults();
            maxDepth = XDebugPreferenceMgr.getDepthDefault();
        }
        sessionPrefs.setValue("MaxDepth", maxDepth);
        int maxChildren = PHPDebugPreferencesUtil.getInt(XDEBUG_PREF_CHILDREN, XDebugPreferenceMgr.getChildrenDefault());
        sessionPrefs.setValue("MaxChildren", maxChildren);
        boolean getSuperGlobals = PHPDebugPreferencesUtil.getBoolean(XDEBUG_PREF_SHOWSUPERGLOBALS, XDebugPreferenceMgr.showSuperGlobalsDefault());
        sessionPrefs.setValue("ShowGlobals", getSuperGlobals);
        int captureStdout = PHPDebugPreferencesUtil.getInt(XDEBUG_PREF_CAPTURESTDOUT, XDebugPreferenceMgr.getCaptureDefault());
        sessionPrefs.setValue("CaptureStdout", captureStdout);
        int captureStderr = PHPDebugPreferencesUtil.getInt(XDEBUG_PREF_CAPTURESTDERR, XDebugPreferenceMgr.getCaptureDefault());
        sessionPrefs.setValue("CaptureStderr", captureStderr);
        return sessionPrefs;
    }

    public static int getPort() {
        return PHPDebugPreferencesUtil.getInt(XDEBUG_PREF_PORT, XDebugPreferenceMgr.getPortDefault());
    }

    public static void setPort(int port) {
        IEclipsePreferences prefs = new InstanceScope().getNode("com.aptana.php.debug.epl");
        prefs.putInt(XDEBUG_PREF_PORT, port);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            PHPDebugEPLPlugin.logError(e);
        }
    }

    public static boolean useMultiSession() {
        return PHPDebugPreferencesUtil.getBoolean(XDEBUG_PREF_MULTISESSION, XDebugPreferenceMgr.useMultiSessionDefault());
    }

    public static boolean useProxy() {
        return PHPDebugPreferencesUtil.getBoolean(XDEBUG_PREF_USEPROXY, false);
    }

    public static void setUseProxy(boolean newState) {
        IEclipsePreferences prefs = new InstanceScope().getNode("com.aptana.php.debug.epl");
        prefs.putBoolean(XDEBUG_PREF_USEPROXY, newState);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            PHPDebugEPLPlugin.logError(e);
        }
    }

    public static AcceptRemoteSession getAcceptRemoteSession() {
        int rSess = PHPDebugPreferencesUtil.getInt(XDEBUG_PREF_REMOTESESSION, XDebugPreferenceMgr.getAcceptRemoteSessionDefault());
        return AcceptRemoteSession.values()[rSess];
    }

    private static int getDepthDefault() {
        return 3;
    }

    private static int getChildrenDefault() {
        return 31;
    }

    private static int getPortDefault() {
        return 9000;
    }

    private static boolean showSuperGlobalsDefault() {
        return true;
    }

    private static int getCaptureDefault() {
        return CaptureOutput.copy.ordinal();
    }

    private static boolean useMultiSessionDefault() {
        return false;
    }

    private static int getAcceptRemoteSessionDefault() {
        return AcceptRemoteSession.localhost.ordinal();
    }

    public static enum AcceptRemoteSession {
        off,
        localhost,
        any,
        prompt;

    }

    public static enum CaptureOutput {
        off,
        copy,
        redirect;

    }
}

